/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.PIHscLockPolicy;
import com.ibm.hsc.lock.Lockable;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider20.AssociatorProvider;

public abstract class PIHscProviderBase {
    protected ProviderCIMOMHandle m_CimomHandle = null;
    protected InstanceProvider m_InnerIProvider = null;
    protected AssociatorProvider m_InnerAProvider = null;
    protected String m_Namespace = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        System.err.println("Initialize the HSCProviderBase ... " + this);
        this.m_CimomHandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.m_InnerIProvider = this.m_CimomHandle.getInternalProvider();
        this.m_InnerAProvider = (AssociatorProvider)this.m_InnerIProvider;
    }

    public void cleanup() throws CIMException {
        System.err.println("In " + this.getClass().getName() + " cleanup");
        this.m_InnerIProvider.cleanup();
        this.m_InnerIProvider = null;
        this.m_InnerAProvider = null;
        this.m_CimomHandle = null;
    }

    protected abstract Lockable getLockable(String var1, CIMObjectPath var2, Vector var3) throws PIHscServerException, CIMException;

    protected abstract boolean hasPermission();

    protected Lockable obtainLock(String string, CIMObjectPath cIMObjectPath, Vector vector) throws PIHscServerException, CIMException {
        String string2 = cIMObjectPath.getObjectName();
        PIHscLockPolicy pIHscLockPolicy = PIHscLockPolicy.getPIHscLockPolicy(string2);
        int n = pIHscLockPolicy.getLockType(string);
        Lockable lockable = null;
        if (n != -1 && (lockable = this.getLockable(string, cIMObjectPath, vector)) != null) {
            lockable.lock(n);
        }
        return lockable;
    }

    protected void releaseLock(Lockable lockable) {
        if (lockable == null) {
            return;
        }
        try {
            lockable.unlock();
        }
        catch (PIHscServerException pIHscServerException) {
            pIHscServerException.printStackTrace();
        }
    }

    protected void setNameSpace(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.m_Namespace != null) {
            if (this.m_Namespace.equalsIgnoreCase(cIMObjectPath.getNameSpace())) {
                return;
            }
        } else {
            this.m_Namespace = cIMObjectPath.getNameSpace();
            return;
        }
        throw new CIMException("CIM_ERR_INVALID_NAMESPACE");
    }
}

